
if (!Stationery) {
    Stationery = {};
}


Stationery.deviceMetrics = {
    lang: "en-US"
};

// Return a json obj with name and thumbUrl
Stationery.getSupportedThemes = function (isCorp, lang) {

    Stationery.deviceMetrics.lang = lang;

    var supportedThemes = [],
        themesInOrder = Stationery.templates.supportedThemesInOrder,
        themeName,
        themeVer,
        thumbLink,
        baseUrl,
        i;

    baseUrl = Stationery.stationeryThemeConfig.stationeryMobThmPath;

    for (i in themesInOrder) {
        themeName = themesInOrder[i];
        themeObj = Stationery.stationeryThemeConfig.stationeryThemes[themeName];

        if (!themeObj || (!isCorp && themeObj.restricted) || !themeObj.supportedLang_regex.test(lang)) {
            continue;
        } else {
            themeVer = Stationery.stationeryThemeConfig.themeVersions[themeName];

            if (themeVer && themeObj) {
                thumbLink = baseUrl + themeVer + '/' + themeName + '/' + themeObj.thmbnailImg;
            } else {
                thumbLink = baseUrl + themeObj.thmbnailImg;
            }

            var themeItem = {
                themeName: themeName,
                thumbLink: thumbLink,
                displayName: themeObj.themeDisplayName
            };

            supportedThemes.push(themeItem);
        }
    }

    try {
        var jsonStr = JSON.stringify({themeItems: supportedThemes});
        yMailBridge.initStationeryList(jsonStr);
    } catch(err) {
        console.log(err);
    }
};
